close all
seed=0;
sLL=50;

textfile = sprintf('%dTraj%d.txt',seed,sLL);

fileID = fopen(textfile,'r');
formatSpec = '%d';

A = fscanf(fileID,formatSpec);

for i=1:50050
    if A(i)>-1
        A(i)=1;
    end
end

B=zeros(50,1000);

for i=1:1001 %Every Cloning Interval
    for j=1:50 %Every Site
        B(j,i) = -1*A((i-1)*50 + j);
    end
end

mesh(B);
colormap(gray);
xlim([0,1000]);
ylim([1,50]);
view(2);

xlabel('Time');
ylabel('Site Index');

set(gca, 'FontSize', 16);
dxt = linspace(0,10000,6);
set(gca, 'XTickLabel', dxt);
yticks([25, 50])
set(gcf,'units','points','position',[10,10,360,150])


plotname = sprintf('%dTraj%d.png',seed,sLL);
saveas(gcf,plotname);